package gui;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;

import javax.swing.WindowConstants;


/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class OptionsFrame extends javax.swing.JFrame implements ActionListener{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JRadioButton jStandard;
	private JButton Ok;
	private ButtonGroup buttonGroup1;
	private JButton jCancel;
	private JRadioButton jPlus;
	private JLabel jLabel1;
	
	public OptionsFrame() {
		super();
		initGUI();
	}
	
	private void initGUI() {
		try {
			setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
			getContentPane().setLayout(null);
			{
				jLabel1 = new JLabel();
				getContentPane().add(jLabel1);
				jLabel1.setText("Select orchestrator:");
				jLabel1.setBounds(12, 28, 159, 16);
			}
			{
				jStandard = new JRadioButton();
				getContentPane().add(jStandard);
				jStandard.setText("Standard");
				jStandard.setBounds(131, 55, 168, 20);
			}
			{
				jPlus = new JRadioButton();
				getContentPane().add(jPlus);
				jPlus.setText("Plus");
				jPlus.setBounds(131, 84, 168, 20);
			}
			{
				Ok = new JButton();
				getContentPane().add(Ok);
				Ok.setText("Ok");
				Ok.setBounds(52, 121, 69, 22);
				Ok.addActionListener(this);
			}
			{
				jCancel = new JButton();
				getContentPane().add(jCancel);
				jCancel.setText("Cancel");
				jCancel.setBounds(166, 121, 78, 22);
				jCancel.addActionListener(this);
			}
			{
			}
			getButtonGroup1();
			pack();
			this.setSize(320, 218);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private ButtonGroup getButtonGroup1() {
		if(buttonGroup1 == null) {
			buttonGroup1 = new ButtonGroup();
			buttonGroup1.add(jStandard);
			buttonGroup1.add(jPlus);
			FileInputStream in;
			Properties applicationProps=new Properties();
			try {
				in = new FileInputStream("symphony.conf");
				applicationProps.load(in);
				in.close();
				String orchestrator_prop=applicationProps.getProperty("orchestrator");
				if(orchestrator_prop.equals("standard"))
					jStandard.setSelected(true);
				else if(orchestrator_prop.equals("plus"))
					jPlus.setSelected(true);

			}catch(Exception e){
				e.printStackTrace();
			}}
		return buttonGroup1;
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		if(e.getSource().equals(jCancel))
			this.setVisible(false);
		if(e.getSource().equals(Ok)){
			byte orchestrator_selected=0;
			if(jStandard.isSelected())
				orchestrator_selected=GenericLoader.ORCHESTRATOR_STANDARD;
			if(jPlus.isSelected())
				orchestrator_selected=GenericLoader.ORCHESTRATOR_PLUS;

			if(GenericLoader.orchestratorIsStarted()){
				JOptionPane.showMessageDialog(this, "Stop the orchestrator before to change options");
				return;
			}
			Properties applicationProps=new Properties();
			if(orchestrator_selected==GenericLoader.ORCHESTRATOR_STANDARD)
				applicationProps.put("orchestrator", "standard");
			if(orchestrator_selected==GenericLoader.ORCHESTRATOR_PLUS)
				applicationProps.put("orchestrator", "plus");
			GenericLoader.setOrchestrator(orchestrator_selected);
			FileOutputStream out;
			try {
				out = new FileOutputStream("symphony.conf");
				applicationProps.store(out, "");
				out.close();
			} catch (FileNotFoundException e2) {
				e2.printStackTrace();
			} catch (IOException e1) {
				e1.printStackTrace();
			}			
			this.setVisible(false);
		}
			
	}

}
